--------------------------------------------------------------------------
-- GTFO_Fail_BFA.lua 
--------------------------------------------------------------------------
--[[
GTFO Fail List - Battle for Azeroth
]]--

if (not (GTFO.ClassicMode or GTFO.BurningCrusadeMode)) then
--- ******************************
--- * Battle for Azeroth (World) *
--- ******************************


GTFO.SpellID["268216"] = {
  --desc = "Earth Shattering (Azerite War Machine)";
  sound = 3;
};

GTFO.SpellID["269560"] = {
  --desc = "Landmine Explosion ";
  sound = 3;
};

GTFO.SpellID["262250"] = {
  --desc = "Blinded by the Light";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["263626"] = {
  --desc = "Icy Glare (Lady Jaina Proudmoore)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["263874"] = {
  --desc = "Blizzard (Lady Jaina Proudmoore)";
  sound = 3;
};

GTFO.SpellID["264973"] = {
  --desc = "Frost Barrage (Lady Jaina Proudmoore)";
  sound = 3;
};

GTFO.SpellID["276899"] = {
  --desc = "Tempest Strike (Lord Stormsong)";
  sound = 3;
};

GTFO.SpellID["276914"] = {
  --desc = "Wrath of Storms";
  sound = 3;
};

GTFO.SpellID["215705"] = {
  --desc = "Gasp of Unmaking (Azshj'thul the Drowned)";
  sound = 3;
  tankSound = 0;
};

GTFO.SpellID["270662"] = {
  --desc = "Boulder (Demolisher)";
  sound = 3;
};

GTFO.SpellID["271437"] = {
  --desc = "Sapper Charge";
  sound = 3;
};

GTFO.SpellID["276973"] = {
  --desc = "Meteor (Champion Lockjaw)";
  sound = 3;
};

GTFO.SpellID["276763"] = {
  --desc = "Lava Storm (Yarsel'ghun)";
  sound = 3;
};

GTFO.SpellID["244787"] = {
  --desc = "Wide Swipe (Crazed Bone Snapper)";
  sound = 3;
};

GTFO.SpellID["265481"] = {
  --desc = "Big Knock Back";
  sound = 3;
};

GTFO.SpellID["276262"] = {
  --desc = "Lightning Storm (Lady Rash'iss)";
  sound = 3;
};

GTFO.SpellID["264465"] = {
  --desc = "Barrel Aged (Barman Bill)";
  sound = 3;
};

GTFO.SpellID["264403"] = {
  --desc = "Hoppy Finish (Barman Bill)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["266288"] = {
  --desc = "Gnash (Vicious Vicejaw)";
  sound = 3;
};

GTFO.SpellID["270460"] = {
  --desc = "Stone Eruption (Goldenvein)";
  sound = 3;
};

GTFO.SpellID["257351"] = {
  --desc = "Thorned Burst (Rindlewoe)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["277044"] = {
  --desc = "Tidal Force (Kvaldir Dreadbringer)";
  sound = 3;
};

GTFO.SpellID["271713"] = {
  --desc = "Elemental Slam (Unbound Azerite)";
  sound = 3;
  tankSound = 0;
};

GTFO.SpellID["266288"] = {
  --desc = "Gnash (Mudsnout Thornback)";
  sound = 3;
};

GTFO.SpellID["244882"] = {
  --desc = "Cracking Blow (Guuru the Mountain-Breaker)";
  sound = 3;
};

GTFO.SpellID["277347"] = {
  --desc = "Whirling Venom (Shipwrecked Strongarm)";
  sound = 3;
  applicationOnly = true;
};

GTFO.SpellID["275823"] = {
  --desc = "Ground Spike (Duster)";
  sound = 3;
};

GTFO.SpellID["273909"] = {
  --desc = "Steelclaw Trap";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["250509"] = {
  --desc = "Shadow Bomb (Icetusk Prophet)";
  sound = 3;
};

GTFO.SpellID["263940"] = {
  --desc = "Trample (Gahz'ralka)";
  sound = 3;
};

GTFO.SpellID["260273"] = {
  --desc = "Void Swipe (Overseer Bates)";
  sound = 3;
};

GTFO.SpellID["280422"] = {
  --desc = "Crushing Dread (Gorak Tul)";
  sound = 3;
  applicationOnly = true;
};

GTFO.SpellID["257336"] = {
  --desc = "Mighty Slam (Lumbergrasp Sentinel)";
  sound = 3;
};

GTFO.SpellID["265720"] = {
  --desc = "Poison Spray (Thu'zun the Vile)";
  sound = 3;
  applicationOnly = true;
};

GTFO.SpellID["266144"] = {
  --desc = "Poison Bomb (Thu'zun the Vile)";
  sound = 3;
  applicationOnly = true;
};

GTFO.SpellID["275243"] = {
  --desc = "Soulburst (Erupting Servant)";
  sound = 3;
};

GTFO.SpellID["271805"] = {
  --desc = "Rez'okun's Rake (Captain Rez'okun)";
  sound = 3;
};

GTFO.SpellID["259669"] = {
  --desc = "Slowed by Snow";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["278177"] = {
  --desc = "Trample (Evergrove Keeper)";
  sound = 3;
};

GTFO.SpellID["257880"] = {
  --desc = "Aquabomb (Deepsea Tidecrusher)";
  sound = 3;
};

GTFO.SpellID["270814"] = {
  --desc = "Hydro Eruption (Deepsea Tidecrusher)";
  sound = 3;
};

GTFO.SpellID["265721"] = {
  --desc = "Web Spray (Ironweb Weaver)";
  sound = 3;
  applicationOnly = true;
};

GTFO.SpellID["261735"] = {
  --desc = "Scouring Sand (Ghost of the Deep)";
  sound = 3;
  applicationOnly = true;
};

GTFO.SpellID["274904"] = {
  --desc = "Reality Tear (Warbringer Yenajz)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["277632"] = {
  --desc = "Demolisher Cannon (Doom's Howl Turret)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["271163"] = {
  --desc = "Shattering Pulse (Doom's Howl)";
  sound = 3;
  tankSound = 0;
};

GTFO.SpellID["264687"] = {
  --desc = "Unleashed Justice (Echo of Myzrael)";
  sound = 3;
};

GTFO.SpellID["269794"] = {
  --desc = "Throw Boulder (Fozruk)";
  sound = 3;
};

GTFO.SpellID["278120"] = {
  --desc = "Star Shower (Ragebeak)";
  sound = 3;
};

GTFO.SpellID["269680"] = {
  --desc = "Entanglement (Branchlord Aldrus)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["274829"] = {
  --desc = "Gale Force (Azurethos)";
  sound = 3;
};

GTFO.SpellID["274840"] = {
  --desc = "Azurethos' Fury (Azurethos)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["265752"] = {
  --desc = "Devastator Cannon (War Machine)";
  sound = 3;
};

GTFO.SpellID["274206"] = {
  --desc = "Blood Wave (Grand Ma'da Ateena)";
  sound = 3;
};

GTFO.SpellID["258094"] = {
  --desc = "Breath of Vol'jamba (Vol'jamba)";
  sound = 3;
};

GTFO.SpellID["269823"] = {
  --desc = "Ball Lightning";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["283876"] = {
  --desc = "High-Explosive Bomb (Base Cap'n Crankshot)";
  sound = 3;
};

GTFO.SpellID["257971"] = {
  --desc = "Leaping Thrash (Bajiatha)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["287537"] = {
  --desc = "Plague Breath (Ivus the Decayed)";
  sound = 3;
  tankSound = 0;
};

GTFO.SpellID["287537"] = {
  --desc = "Plague Breath (Ivus the Decayed)";
  sound = 3;
};

GTFO.SpellID["284949"] = {
  --desc = "Warden's Prison (Sira Moonwarden)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["288949"] = {
  --desc = "Crash Override (Shredmaster Blix)";
  sound = 3;
};

GTFO.SpellID["287203"] = {
  --desc = "Trapped";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["289004"] = {
  --desc = "Stone Smash (Stone Sentinel)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["286059"] = {
  --desc = "A Painful Amount of Damage (Opulence)";
  sound = 3;
};

GTFO.SpellID["286699"] = {
  --desc = "Bwonsamdi's Gaze";
  sound = 3;
};

GTFO.SpellID["261552"] = {
  --desc = "Terror Wail (T'zane)";
  sound = 3;
};

GTFO.SpellID["261597"] = {
  --desc = "Coalesced Essence (T'zane)
  sound = 3
};

GTFO.SpellID["286525"] = {
  --desc = "Poison Spray (Injured Bristlequeen)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["295469"] = {
  --desc = "Falling Rocks (Rockfall)";
  sound = 3;
};

GTFO.SpellID["301146"] = {
  --desc = "Shattering Smash (Ma'haat the Indomitable)";
  sound = 3;
};

GTFO.SpellID["301145"] = {
  --desc = "Shattering Smash (Ma'haat the Indomitable)";
  sound = 3;
};

GTFO.SpellID["301802"] = {
  --desc = "Water Wall";
  sound = 3;
};

GTFO.SpellID["299994"] = {
  --desc = "Vent Blast (HK-8 Aerial Oppression Unit)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["299947"] = {
  --desc = "Cannon Blast (HK-8 Aerial Oppression Unit)";
  sound = 3;
};

GTFO.SpellID["244888"] = {
  --desc = "Bonk (Moch'k Eight-Thumbs)";
  sound = 3;
};

GTFO.SpellID["304200"] = {
  --desc = "Azerite Cannon (Unit One-Thirty Three-Seven)";
  sound = 3;
};

GTFO.SpellID["304460"] = {
  --desc = "Dark Glaive (Lyani)";
  sound = 3;
};

GTFO.SpellID["300257"] = {
  --desc = "Firestorm (Magister Hathorel)";
  sound = 3;
};

GTFO.SpellID["304348"] = {
  --desc = "Annihilation (Magister Hathorel)";
  sound = 3;
};

GTFO.SpellID["302181"] = {
  --desc = "Maniacal Laugh (Junkbrat)";
  sound = 3;
};

GTFO.SpellID["303167"] = {
  --desc = "Tideslam (Zanj'ir Bulwark)";
  sound = 3;
};

GTFO.SpellID["285460"] = {
  --desc = "Discom-BOMB-ulator (Bondo Bigblock)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["266151"] = {
  --desc = "Fire Bomb (Flamescale Wavebreaker)";
  applicationOnly = true;
  sound = 3;
}

GTFO.SpellID["286907"] = {
  --desc = "Volatile Eruption (Azergem Crystalback)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["304176"] = {
  --desc = "Mystic Tornado (Mystic Tornado)";
  sound = 3;
};

GTFO.SpellID["294894"] = {
  --desc = "Malfunction Sparks (Malfunctioning Scrapboss)";
  sound = 3;
};

GTFO.SpellID["302207"] = {
  --desc = "Proximal Chaos (Unleashed Arcanofiend)";
  sound = 3;
};

GTFO.SpellID["301774"] = {
  --desc = "Mental Collapse (Moon Priestess Liara)";
  sound = 3;
};

GTFO.SpellID["302305"] = {
  --desc = "Twilight Barrage (Void Horror)";
  sound = 3;
};

GTFO.SpellID["308357"] = {
  --desc = "Piercing Shot (Fallen Heartpiercer)";
  sound = 3;
};

GTFO.SpellID["308508"] = {
  --desc = "Rift Strike (Fallen Riftwalker)";
  sound = 3;
};

GTFO.SpellID["308481"] = {
  --desc = "Rift Strike (Fallen Riftwalker)";
  sound = 3;
};

GTFO.SpellID["308288"] = {
  --desc = "Darkened Sky (Alleria Windrunner)";
  sound = 3;
};

GTFO.SpellID["309819"] = {
  --desc = "Void Eruption (Alleria Windrunner)";
  sound = 3;
};

GTFO.SpellID["298770"] = {
  --desc = "Chains of Servitude (Slavemaster Ul'rok)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["314306"] = {
  --desc = "Song of the Empress (Grand Empress Shek'zara)";
  applicationOnly = true;
  sound = 3;
};

-- ***********************
-- * Shrine of the Storm *
-- ***********************

GTFO.SpellID["267973"] = {
  --desc = "Wash Away (Temple Attendant)";
  sound = 3;
};

GTFO.SpellID["268059"] = {
  --desc = "Anchor of Binding (Tidesage Spiritualist)";
  sound = 3;
};

GTFO.SpellID["264773"] = {
  --desc = "Choking Brine (Aqu'sirr)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["267899"] = {
  --desc = "Hindering Cleave (Brother Ironhull)";
  sound = 3;
  tankSound = 0;
};

GTFO.SpellID["268280"] = {
  --desc = "Tidal Pod (Tidesage Enforcer)";
  sound = 3;
};

GTFO.SpellID["268391"] = {
  --desc = "Mental Assault (Abyssal Cultist)";
  applicationOnly = true;
  test = true; -- Is this actually avoidable?
  sound = 3;
};

GTFO.SpellID["269104"] = {
  --desc = "Explosive Void (Lord Stormsong)";
  sound = 3;
};

GTFO.SpellID["267956"] = {
  --desc = "Zap (Jellyfish)";
  sound = 3;
};

GTFO.SpellID["267385"] = {
  --desc = "Tentacle Slam (Vol'zith the Whisperer)";
  sound = 3;
};

GTFO.SpellID["265495"] = {
  --desc = "Static Orb";
  sound = 3;
  test = true;
};

GTFO.SpellID["300660"] = {
  --desc = "Solar Beam (Watcher Statue)";
  sound = 3;
};

GTFO.SpellID["317595"] = {
  --desc = "Gaze of Judgment (Watcher Aum-ka)";
  sound = 3;
};

GTFO.SpellID["280462"] = {
  --desc = "Holy Wave (Watcher Aum-ka)";
  sound = 3;
  applicationOnly = true;
};

GTFO.SpellID["312854"] = {
  --desc = "Concentric Reverberations (Shoth the Darkened)";
  sound = 3;
};

GTFO.SpellID["312856"] = {
  --desc = "Concentric Reverberations (Shoth the Darkened)";
  sound = 3;
};

GTFO.SpellID["302454"] = {
  --desc = "Corrupted Frost Fragment (Vexiona)";
  sound = 3;
};

GTFO.SpellID["302456"] = {
  --desc = "Corrupted Flame Fragment (Vexiona)";
  sound = 3;
};

GTFO.SpellID["315894"] = {
  --desc = "Glowing Fragment (Sun King Nahkotep)";
  sound = 3;
};

GTFO.SpellID["314722"] = {
  --desc = "Solar Detonation (Watcher Rehu)";
  sound = 3;
};

GTFO.SpellID["302919"] = {
  --desc = "Spear Trap";
  sound = 3;
};

GTFO.SpellID["303743"] = {
  --desc = "Spear Trap";
  sound = 3;
};

GTFO.SpellID["319944"] = {
  --desc = "Void Destruction (Yox'ith)";
  sound = 3;
};

GTFO.SpellID["306529"] = {
  --desc = "Falling Debris";
  sound = 3;
};

GTFO.SpellID["316016"] = {
  --desc = "Void Storm (Extractor Thelsara)";
  sound = 3;
};

GTFO.SpellID["316538"] = {
  --desc = "Dark Outburst (Spawn of Shad'har)";
  sound = 3;
};

GTFO.SpellID["306900"] = {
  --desc = "Molten Eruption";
  sound = 3;
};

GTFO.SpellID["316609"] = {
  --desc = "Skull Breaker (Terror Tendril)";
  sound = 3;
};

GTFO.SpellID["310066"] = {
  --desc = "Lightning Strike";
  sound = 3;
};

GTFO.SpellID["306765"] = {
  --desc = "Surging Darkness (Thrall)";
  sound = 3;
};

GTFO.SpellID["297746"] = {
  --desc = "Seismic Slam (Thrall)";
  sound = 3;
};

GTFO.SpellID["291338"] = {
  --desc = "Blooddrinker (Madness: Bloodthirsty)";
  sound = 4;
};

GTFO.SpellID["305369"] = {
  --desc = "Break Spirit (Voidbound Honor Guard)";
  sound = 3;
};

-- ******************
-- * Waycrest Manor *
-- ******************

GTFO.SpellID["263905"] = {
  --desc = "Marking Cleave (Heartsbane Runeweaver)";
  sound = 3;
  tankSound = 0;
  test = true;
};

GTFO.SpellID["264531"] = {
  --desc = "Shrapnel Trap (Maddened Survivalist)";
  sound = 3;
  test = true;
};

GTFO.SpellID["264476"] = {
  --desc = "Tracking Explosive (Crazed Marksman)";
  sound = 3;
  test = true;
};

GTFO.SpellID["271174"] = {
  --desc = "Retch (Pallid Gorger)";
  sound = 3;
  tankSound = 0;
};

GTFO.SpellID["264923"] = {
  --desc = "Tenderize (Raal the Gluttonous)";
  sound = 3;
};

GTFO.SpellID["265757"] = {
  --desc = "Splinter Spike (Matron Bryndle)";
  sound = 3;
};

GTFO.SpellID["264150"] = {
  --desc = "Shatter (Thornguard)";
  sound = 3;
  test = true;
};

GTFO.SpellID["265372"] = {
  --desc = "Shadow Cleave (Enthralled Guard)";
  sound = 3;
  tankSound = 0;
};

GTFO.SpellID["265352"] = {
  --desc = "Toad Blight (Blight Toad)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["288922"] = {
  --desc = "Call Meteor (Aman)";
  sound = 3;
};

GTFO.SpellID["288951"] = {
  --desc = "Burning (Burninator Mark V)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["288716"] = {
  --desc = "Fire Fall (Conflagros)";
  sound = 3;
};



-- ************
-- * Freehold *
-- ************

GTFO.SpellID["258673"] = {
  --desc = "Azerite Grenade (Irontide Crackshot)";
  sound = 3;
};

GTFO.SpellID["256106"] = {
  --desc = "Azerite Powder Shot (Skycap'n Kragg)";
  sound = 3;
  tankSound = 0;
  test = true;
};

GTFO.SpellID["258773"] = {
  --desc = "Charrrrrge (Skycap'n Kragg)";
  sound = 3;
};

GTFO.SpellID["258779"] = {
  --desc = "Sea Spout (Irontide Oarsman)";
  sound = 3;
  negatingDebuffSpellID = 274389;  -- Rat Trap
  -- negatingDebuffSpellID = 274400; -- Duelist Dash
  -- TODO: Add support for multiple spell IDs
};

GTFO.SpellID["272374"] = {
  --desc = "Whirlpool of Blades (Captain Jolly)";
  sound = 3;
};

GTFO.SpellID["267523"] = {
  --desc = "Cutting Surge (Captain Jolly)";
  sound = 3;
  applicationOnly = true;
};

GTFO.SpellID["256594"] = {
  --desc = "Barrel Smash (Captain Raoul)";
  sound = 3;
};

GTFO.SpellID["257310"] = {
  --desc = "Cannon Barrage (Harlan Sweete)";
  sound = 3;
  test = true;
};

GTFO.SpellID["257315"] = {
  --desc = "Black Powder Bomb (Harlan Sweete)";
  sound = 3;
  test = true;
};

GTFO.SpellID["272397"] = {
  --desc = "Whirlpool of Blades";
  sound = 3;
};

GTFO.SpellID["276061"] = {
  --desc = "Boulder Throw (Irontide Crusher)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["258199"] = {
  --desc = "Ground Shatter (Irontide Crusher)";
  sound = 3;
};

GTFO.SpellID["257902"] = {
  --desc = "Shell Bounce (Ludwig Von Tortollan)";
  sound = 3;
};

GTFO.SpellID["258352"] = {
  --desc = "Grapeshot (Captain Eudora)";
  sound = 3;
};

-- *************
-- * Tol Dagor *
-- *************

GTFO.SpellID["257119"] = {
  --desc = "Sand Trap (The Sand Queen)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["257785"] = {
  --desc = "Flashing Daggers (Jes Howlis)";
  sound = 3;
};

GTFO.SpellID["256710"] = {
  --desc = "Burning Arsenal";
  sound = 3;
};

GTFO.SpellID["256955"] = {
  --desc = "Cinderflame (Knight Captain Valyri)";
  sound = 3;
  test = true; -- Avoidable by tank?
};

GTFO.SpellID["256976"] = {
  --desc = "Ignition (Knight Captain Valyri)";
  sound = 3;
};

GTFO.SpellID["258917"] = {
  --desc = "Righteous Flames (Ashvane Priest)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["259711"] = {
  --desc = "Lockdown (Ashvane Warden)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["258634"] = {
  --desc = "Fuselighter (Ashvane Flamecaster)";
  sound = 3;
};

-- ****************
-- * The Underrot *
-- ****************

GTFO.SpellID["265019"] = {
  --desc = "Savage Cleave (Chosen Blood Matron)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["265665"] = {
  --desc = "Foul Sludge (Living Rot)";
  sound = 3;
};

GTFO.SpellID["260793"] = {
  --desc = "Indigestion (Cragmaw the Infested)";
  sound = 3;
};

GTFO.SpellID["259720"] = {
  --desc = "Upheaval (Sporecaller Zancha)";
  sound = 3;
};

GTFO.SpellID["273226"] = {
  --desc = "Decaying Spores (Sporecaller Zancha)";
  applicationOnly = true;
  sound = 3;
  minimumStacks = 3;
  test = true;
};

GTFO.SpellID["265511"] = {
  --desc = "Spirit Drain (Spirit Drain Totem)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["272609"] = {
  --desc = "Maddening Gaze (Faceless Corruptor)";
  sound = 3;
  applicationOnly = true;
};

GTFO.SpellID["273475"] = {
  --desc = "Rotten Breath (Rotmaw)";
  sound = 3;
  applicationOnly = true;
};

-- ************************
-- * Temple of Sethraliss *
-- ************************

GTFO.SpellID["272657"] = {
  --desc = "Noxious Breath (Scaled Krolusk Rider)";
  sound = 3;
  applicationOnly = true;
};

GTFO.SpellID["273225"] = {
  --desc = "Volley (Sandswept Marksman)";
  sound = 3;
};

GTFO.SpellID["264206"] = {
  --desc = "Burrow (Merektha)";
  sound = 3;
};

GTFO.SpellID["269970"] = {
  --desc = "Blinding Sand (Merektha)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["267483"] = {
  --desc = "Loose Sparks (Loose Spark)";
  sound = 3;
};

GTFO.SpellID["264763"] = {
  --desc = "Spark (Static-charged Dervish)";
  sound = 3;
};

GTFO.SpellID["272821"] = {
  --desc = "Call Lightning (Imbued Stormcaller)";
  sound = 3;
};

GTFO.SpellID["255741"] = {
  --desc = "Cleave (Scaled Krolusk Rider)";
  sound = 3;
  tankSound = 0;
  test = true; -- Restrict to this NPC only
};

-- ********************
-- * The MOTHERLODE!! *
-- ********************

GTFO.SpellID["256137"] = {
  --desc = "Timed Detonation (Azerite Footbomb)";
  sound = 3;
};

GTFO.SpellID["268365"] = {
  --desc = "Mining Charge";
  sound = 3;
};

GTFO.SpellID["271583"] = {
  --desc = "Black Powder Special";
  sound = 3;
};

GTFO.SpellID["263105"] = {
  --desc = "Blowtorch (Feckless Assistant)";
  sound = 3;
  tankSound = 0;
};

GTFO.SpellID["269092"] = {
  --desc = "Artillery Barrage (Ordnance Specialist)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["262377"] = {
  --desc = "Seek and Destroy (Crawler Mine)";
  applicationOnly = true;
  sound = 3;
  tankSound = 0;
};

-- **************
-- * Atal'Dazar *
-- **************

GTFO.SpellID["255558"] = {
  --desc = "Tainted Blood (Gilded Priestess)";
  applicationOnly = true;
  sound = 3;
  test = true; -- Negating debuff during boss ability?
};

GTFO.SpellID["255620"] = {
  --desc = "Festering Eruption (Reanimated Honor Guard)";
  sound = 3;
};

GTFO.SpellID["255620"] = {
  --desc = "Festering Eruption (Reanimated Honor Guard)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["257483"] = {
  --desc = "Pile of Bones (Rezan)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["255371"] = {
  --desc = "Terrifying Visage (Rezan)";
  applicationOnly = true;
  sound = 3;
  test = true; -- Bugged?
};

GTFO.SpellID["258986"] = {
  --desc = "Stink Bomb (Shadowblade Razi)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["277072"] = {
  --desc = "Corrupted Gold (Corrupted Gold)";
  applicationOnly = true;
  sound = 3;
};

-- ***************
-- * King's Rest *
-- ***************

-- TODO: Gale Slash (Dazar, The First King)
-- TODO: Impaling Spear (Dazar, The First King)

GTFO.SpellID["270003"] = {
  --desc = "Suppression Slam (Animated Guardian)";
  sound = 3;
};

GTFO.SpellID["265781"] = {
  --desc = "Serpentine Gust (The Golden Serpent)";
  sound = 3;
};

GTFO.SpellID["270872"] = {
  --desc = "Shadow Whirl (Bloodsworn Agent)";
  sound = 3;
};

GTFO.SpellID["275212"] = {
  --desc = "Bisecting Strike (Weaponmaster Halu)";
  sound = 3;
};

GTFO.SpellID["270289"] = {
  --desc = "Purification Beam";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["267105"] = {
  --desc = "Torrent (Torrent Totem)";
  sound = 3;
};

-- ********************
-- * Siege of Boralus *
-- ********************

GTFO.SpellID["256866"] = {
  --desc = "Iron Ambush (Riptide Shredder)";
  sound = 3;
  applicationOnly = true;
};

GTFO.SpellID["272426"] = {
  --desc = "Sighted Artillery";
  sound = 3;
};

GTFO.SpellID["274942"] = {
  --desc = "Banana Rampage";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["272713"] = {
  --desc = "Crushing Slam (Bilge Rat Demolisher)";
  sound = 3;
};

GTFO.SpellID["277535"] = {
  --desc = "Viq'Goth's Wrath (Viq'Goth)";
  sound = 3;
};

-- TODO: Cannon Barrage (Chopper Redhook) -- Avoidable?
-- TODO: Heavy Slash (Irontide Cleaver) -- Non-Tank only? Avoidable?
-- TODO: Clear the Deck (Dread Captain Lockwood) -- Non-Tank only? Avoidable?
-- TODO: Crimson Swipe (Ashvane Deckhand) -- Non-Tank only? Avoidable?
-- TODO: Broadside (Ashvane Cannoneer) -- Avoidable?

GTFO.SpellID["261565"] = {
  --desc = "Crashing Tide (Hadal Darkfathom)";
  sound = 3;
  tankSound = 0;
};

GTFO.SpellID["257883"] = {
  --desc = "Break Water (Hadal Darkfathom)";
  sound = 3;
  test = true;
};

GTFO.SpellID["276042"] = {
  --desc = "Tidal Surge";
  sound = 3;
};

-- TODO: Eradication (Viq'Goth) -- Avoidable?

GTFO.SpellID["269266"] = {
  --desc = "Slam (Demolishing Terror)";
  sound = 3;
};

-- *********
-- * Uldir *
-- *********

GTFO.SpellID["271885"] = {
  --desc = "Retrieve Cudgel (Taloc)";
  sound = 3;
};

GTFO.SpellID["272582"] = {
  --desc = "Sanguine Static (Taloc)";
  sound = 3;
};

-- TODO: Hardened Arteries (Taloc) -- Explosion, avoidable?

GTFO.SpellID["267803"] = {
  --desc = "Purifying Flame (MOTHER)";
  sound = 3;
};

GTFO.SpellID["267787"] = {
  --desc = "Sanitizing Strike (MOTHER)";
  applicationOnly = true;
  sound = 3;
  tankSound = 0;
};

GTFO.SpellID["277794"] = {
  --desc = "Paw Swipe (Malformed Lion)";
  applicationOnly = true;
  sound = 3;
  tankSound = 0;
};

-- TODO: Spreading Epidemic (MOTHER) -- What does this do?
-- TODO: Surging Darkness (Zek'voz) -- Avoidable for big pools? Different spell IDs for pool damage vs. incidental
-- TODO: Void Lash (Zek'voz) -- For tanks only, stack tracking, fail at 100% reduction
-- TODO: Ominous Cloud (Zek'voz) -- Touching the cloud failure
-- TODO: Void Wall (Zek'voz) -- Mythic only - Avoidable?
-- TODO: Blood Geyser (Vectis) -- What is this?
-- TODO: Pit of Despair (Zul) -- Avoidable? 
-- TODO: Tendrils of Corruption (G'huun) -- Mythic only
-- TODO: Wave of Corruption (G'huun)
-- TODO: Explosive Corruption (G'huun) -- If standing too close to a player that's infected, not for the infected

GTFO.SpellID["277545"] = {
  --desc = "Shadow Crash (C'Thraxxi Breaker)";
  sound = 3;
};

GTFO.SpellID["277810"] = {
  --desc = "Congealed Plague (Nazmani Defiler)";
  sound = 3;
};

GTFO.SpellID["277813"] = {
  --desc = "Blood Ritual (Speaker Obara)";
  sound = 3;
};

GTFO.SpellID["278933"] = {
  --desc = "Bursting Surge";
  sound = 3;
};

GTFO.SpellID["278890"] = {
  --desc = "Violent Hemorrhage (Nazmani Veinsplitter)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["274358"] = {
  --desc = "Rupturing Blood (Zul)";
  applicationOnly = true;
  sound = 3;
  tankSound = 0;
};

GTFO.SpellID["273316"] = {
  --desc = "Bloody Cleave (Nazmani Crusher)";
  sound = 3;
  tankSound = 0;
};

GTFO.SpellID["273554"] = {
  --desc = "Obliteration Blast (Mythrax the Unraveler)";
  sound = 3;
  negatingDebuffSpellID = 272407;  -- Oblivion Sphere
};

GTFO.SpellID["273282"] = {
  --desc = "Essence Shear (Mythrax the Unraveler)";
  sound = 3;
  tankSound = 0;
};

GTFO.SpellID["262292"] = {
  --desc = "Rotting Regurgitation (Fetid Devourer)";
  sound = 3;
};

GTFO.SpellID["278988"] = {
  --desc = "Wild Leap (Nazmani Dominator)";
  sound = 3;
};

GTFO.SpellID["273486"] = {
  --desc = "Virulent Corruption (G'huun)";
  sound = 3;
};

GTFO.SpellID["273401"] = {
  --desc = "Mind Thrall (G'huun)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["267700"] = {
  --desc = "Gaze of G'huun (G'huun)";
  applicationOnly = true;
  sound = 3;
};

--- *************************
--- * Battle for Dazar'alor *
--- *************************

GTFO.SpellID["290045"] = {
  --desc = "Spear Swipe (Rastari Enforcer)";
  sound = 3;
  tankSound = 0;
};

GTFO.SpellID["283617"] = {
  --desc = "Wave of Light (Ra'wani Kanae)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["283651"] = {
  --desc = "Blinding Faith (Zandalari Crusader)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["284388"] = {
  --desc = "Phoenix Strike (Anathos Firecaller)";
  sound = 3;
};

GTFO.SpellID["284028"] = {
  --desc = "Multi-Sided Strike";
  sound = 3;
};

GTFO.SpellID["282545"] = {
  --desc = "Deathly Echo (Grong the Revenant)";
  sound = 3;
};

GTFO.SpellID["287556"] = {
  --desc = "Soul Barrage (Vengeful Shrieker)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["283609"] = {
  --desc = "Crush (Yalat's Bulwark)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["283610"] = {
  --desc = "Crush (Yalat's Bulwark)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["286040"] = {
  --desc = "Gold Burst (Spirit of Gold)";
  sound = 3;
};

GTFO.SpellID["283574"] = {
  --desc = "Volatile Charge (The Hand of In'zashi)";
  sound = 3;
};

GTFO.SpellID["287640"] = {
  --desc = "Volatile Charge (The Hand of In'zashi)";
  sound = 3;
};

GTFO.SpellID["283557"] = {
  --desc = "Volatile Charge (The Hand of In'zashi)";
  sound = 4;
  ignoreSelfInflicted = true;
};

GTFO.SpellID["289238"] = {
  --desc = "Static Lightning (Echo of Akunda)";
  sound = 3;
};

GTFO.SpellID["282444"] = {
  --desc = "Lacerating Claws (Kimbul's Aspect)";
  sound = 3;
  tankSound = 0;
  applicationOnly = true;
};

GTFO.SpellID["282411"] = {
  --desc = "Thundering Storm (Akunda's Aspect)";
  sound = 3;
};

GTFO.SpellID["282636"] = {
  --desc = "Krag'wa's Wrath (Krag'wa)";
  sound = 3;
};

GTFO.SpellID["289672"] = {
  --desc = "Croak Slam (Echo of Krag'wa)";
  sound = 3;
};

GTFO.SpellID["286838"] = {
  --desc = "Static Orb (Akunda's Aspect)";
  sound = 3;
  applicationOnly = true;
};

GTFO.SpellID["282135"] = {
  --desc = "Crawling Hex (Gonk's Aspect)";
  applicationOnly = true;
  sound = 3;
  specificMobs = { 0 };
};

GTFO.SpellID["288842"] = {
  --desc = "Throw Goods (Furious Merchant)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["287147"] = {
  --desc = "Dread Reaping (King Rhst)";
  sound = 3;
};


GTFO.SpellID["286742"] = {
  --desc = "Necrotic Smash (Phantom of Rage)";
  sound = 3;
};

GTFO.SpellID["285044"] = {
  --desc = "Toad Toxin (Plague Toad)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["288207"] = {
  --desc = "Cannon Fire (Seafarers' Cannon)";
  sound = 3;
};

GTFO.SpellID["287891"] = {
  --desc = "Sheep Shrapnel (High Tinker Mekkatorque)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["282205"] = {
  --desc = "Blast Off (High Tinker Mekkatorque)";
  sound = 3;
};

GTFO.SpellID["282182"] = {
  --desc = "Buster Cannon (High Tinker Mekkatorque)";
  sound = 3;
  applicationOnly = true;
};

GTFO.SpellID["282408"] = {
  --desc = "Spark Pulse (High Tinker Mekkatorque)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["289621"] = {
  --desc = "Churning Depths (Breakwater Elemental)";
  sound = 3;
};

GTFO.SpellID["285125"] = {
  --desc = "Sea Swell (Laminaria)";
  sound = 3;
};

GTFO.SpellID["284374"] = {
  --desc = "Magma Trap (Anathos Firecaller)";
  sound = 3;
};

GTFO.SpellID["288325"] = {
  --desc = "Glacial Shards (Lady Jaina Proudmoore)";
  sound = 3;
};

GTFO.SpellID["288534"] = {
  --desc = "Blistering Tornado (Lady Jaina Proudmoore)";
  sound = 3;
};

GTFO.SpellID["287490"] = {
  --desc = "Frozen Solid (Lady Jaina Proudmoore)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["290030"] = {
  --desc = "Bombard (Lady Jaina Proudmoore)";
  sound = 3;
};

GTFO.SpellID["285177"] = {
  --desc = "Freezing Blast (Lady Jaina Proudmoore)";
  sound = 3;
};

GTFO.SpellID["287585"] = {
  --desc = "Avalanche (Lady Jaina Proudmoore)";
  sound = 3;
};

GTFO.SpellID["289985"] = {
  --desc = "Arcane Barrage (Lady Jaina Proudmoore)";
  sound = 3;
};

GTFO.SpellID["288218"] = {
  --desc = "Broadside (Lady Jaina Proudmoore)";
  sound = 3;
};

GTFO.SpellID["289937"] = {
  --desc = "Thundering Slam (Rastari Punisher)";
  applicationOnly = true;
  sound = 3;
  tankSound = 0;
};

--- **********************
--- * Crucible of Storms *
--- **********************

-- TODO: Oceanic Essence (Restless Cabal)
-- TODO: Cerebral Assault (Zaxasj the Speaker)
-- TODO: Void Crash (Fa'thuul the Feared)
-- TODO: Unstable Resonance (Uu'nat)
-- TODO: Touch of the End (Uu'nat) [Tanks only, others avoid]
-- TODO: Oblivion Tears (Uu'nat) [Complicated mechanic, needs testing, able to soak at specific times]
-- TODO: Void Crash (Uu'nat)
-- TODO: Maddening Eyes of N'Zoth (Uu'nat)
-- TODO: Piercing Gaze of N'Zoth (Uu'nat) [Stackable debuff, affliction only]
-- TODO: Unknowable Terror (Uu'nat) ???

-- ***********************
-- * Operation: Mechagon *
-- ***********************

GTFO.SpellID["300424"] = {
  --desc = "Shockwave (Scrapbone Bully)";
  sound = 3;
};

GTFO.SpellID["296522"] = {
  --desc = "Self-Destruct (King Gobbamak)";
  sound = 3;
};

GTFO.SpellID["297283"] = {
  --desc = "Cave In (King Gobbamak)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["302100"] = {
  --desc = "Cannon Blast (HK-8 Aerial Oppression Unit)";
  sound = 3;
};

GTFO.SpellID["300561"] = {
  --desc = "Explosion (Scrapbone Trashtosser)";
  sound = 3;
};

GTFO.SpellID["300427"] = {
  --desc = "Shockwave (Scrapbone Bully)";
  sound = 3;
};

GTFO.SpellID["299535"] = {
  --desc = "Scrap Blast (Pistonhead Blaster)";
  sound = 3;
};

GTFO.SpellID["298940"] = {
  --desc = "Bolt Buster (Naeno Megacrash)";
  sound = 3;
};

GTFO.SpellID["298588"] = {
  --desc = "Crash (Mechacycle)";
  sound = 3;
};

GTFO.SpellID["300129"] = {
  --desc = "Self-Destruct Protocol (Malfunctioning Scrapbot)";
  sound = 3;
};

GTFO.SpellID["300659"] = {
  --desc = "Consuming Slime (Toxic Monstrosity)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["298259"] = {
  --desc = "Gooped (Gunker)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["295552"] = {
  --desc = "Cannon Blast (HK-8 Aerial Oppression Unit)";
  sound = 3;
};

GTFO.SpellID["296150"] = {
  --desc = "Vent Blast (HK-8 Aerial Oppression Unit)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["296279"] = {
  --desc = "Anti-Trespassing Teleport (HK-8 Aerial Oppression Unit)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["301177"] = {
  --desc = "Lift-Off (HK-8 Aerial Oppression Unit)";
  sound = 3;
};

GTFO.SpellID["294128"] = {
  --desc = "Rocket Barrage (Rocket Tonk)";
  sound = 3;
};

GTFO.SpellID["282945"] = {
  --desc = "Buzz Saw (Buzz Saw)";
  sound = 3;
};

GTFO.SpellID["295130"] = {
  --desc = "Neutralize Threat (Detect-o-Bot)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["294954"] = {
  --desc = "Self-Trimming Hedge (Head Machinist Sparkflux)";
  sound = 3;
};

GTFO.SpellID["285460"] = {
  --desc = "Discom-BOMB-ulator (Head Machinist Sparkflux)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["291915"] = {
  --desc = "Plasma Orb (King Mechagon)";
  sound = 3;
};

GTFO.SpellID["291856"] = {
  --desc = "Recalibrate (King Mechagon)";
  sound = 3;
};

GTFO.SpellID["295183"] = {
  --desc = "Capacitor Discharge (Blastatron X-81)";
  sound = 3;
};

GTFO.SpellID["295168"] = {
  --desc = "Capacitor Discharge (Blastatron X-81)";
  sound = 3;
};

GTFO.SpellID["295169"] = {
  --desc = "Capacitor Discharge (Blastatron X-81)";
  sound = 3;
};

GTFO.SpellID["295170"] = {
  --desc = "Capacitor Discharge (Blastatron X-81)";
  sound = 3;
};

GTFO.SpellID["295182"] = {
  --desc = "Capacitor Discharge (Blastatron X-81)";
  sound = 3;
};

GTFO.SpellID["285377"] = {
  --desc = "B.4.T.T.L.3. Mine (The Platinum Pummeler)";
  sound = 3;
};

GTFO.SpellID["293861"] = {
  --desc = "Anti-Personnel Squirrel (Anti-Personnel Squirrel)";
  sound = 3;
};

-- **********************
-- * The Eternal Palace *
-- **********************

-- TODO: Arcing Current (Orgozoa)
-- TODO: Hatchery Moulting (Orgozoa)
-- TODO: Fanatical Verdict (The Queen's Court)
-- TODO: Tentacle Slam (Za'qul)
-- TODO: Arcane Burst (Queen Azshara)

GTFO.SpellID["303876"] = {
  --desc = "Overwhelming Toxin (Abyssal Commander Sivara)";
  sound = 3;
};

GTFO.SpellID["303875"] = {
  --desc = "Overwhelming Frost (Abyssal Commander Sivara)";
  sound = 3;
};

GTFO.SpellID["293001"] = {
  --desc = "Death from Below (Blackwater Behemoth)";
  sound = 3;
};

GTFO.SpellID["298595"] = {
  --desc = "Glowing Stinger (Blackwater Behemoth)";
  applicationOnly = true;
  sound = 3;
  test = true;
};

GTFO.SpellID["304070"] = {
  --desc = "Arcanado";
  sound = 3;
};

GTFO.SpellID["296421"] = {
  --desc = "Arcanado";
  sound = 3;
};

GTFO.SpellID["304067"] = {
  --desc = "Arcanado Burst (Sak'ja)";
  sound = 3;
};

GTFO.SpellID["296449"] = {
  --desc = "Arcanado Burst (Radiance of Azshara)";
  sound = 3;
};

GTFO.SpellID["304026"] = {
  --desc = "Arcane Bomb (Vizja'ra)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["296746"] = {
  --desc = "Arcane Bomb (Radiance of Azshara)";
  sound = 3;
  applicationOnly = true;
};

GTFO.SpellID["304027"] = {
  --desc = "Arcane Bomb (Radiance of Azshara)";
  sound = 3;
  applicationOnly = true;
};

GTFO.SpellID["299093"] = {
  --desc = "Radiant Fury (Radiance of Azshara)";
  sound = 3;
  test = true;
};

GTFO.SpellID["296555"] = {
  --desc = "Coral Growth (Lady Ashvane)";
  sound = 3;
};

GTFO.SpellID["298054"] = {
  --desc = "Upsurge (Lady Ashvane)";
  sound = 3;
};

GTFO.SpellID["298087"] = {
  --desc = "Dribbling Ichor (Orgozoa)";
  sound = 3;
};

GTFO.SpellID["300308"] = {
  --desc = "Eggsplosion (Orgozoa)";
  sound = 3;
};

GTFO.SpellID["301808"] = {
  --desc = "Zealous Eruption (The Queen's Court)";
  sound = 3;
  test = true;
};

GTFO.SpellID["299705"] = {
  --desc = "Dark Passage (Za'qul)";
  sound = 3;
  applicationOnly = true;
  test = true;
};

GTFO.SpellID["292565"] = {
  --desc = "Crushing Grasp (Za'qul)";
  sound = 3;
};

GTFO.SpellID["298120"] = {
  --desc = "Lightning Orbs (Queen Azshara)";
  sound = 3;
};

GTFO.SpellID["300518"] = {
  --desc = "Arcane Detonation (Queen Azshara)";
  sound = 3;
};

GTFO.SpellID["303963"] = {
  --desc = "Void Slam (Horrific Shrieker)";
  sound = 3;
  tankSound = 0;
};

GTFO.SpellID["303729"] = {
  --desc = "Crackling Tornado (Rak'sha the Swift)";
  sound = 3;
};

-- *************
-- * Ny'alotha *
-- *************

-- TODO: Molten Eruption (Wrathion)
-- TODO: Gale Blast (Wrathion) (Avoid inner blast)
-- TODO: Black Wings (Maut) (?)
-- TODO: Terror Wave (Dark Inquisitor Xanesh)
-- TODO: Doom (Dark Inquisitor Xanesh)
-- TODO: Nullification Blast (Tek'ris)
-- TODO: Entropic Echo (Tek'ris)
-- TODO: Umbral Eruption (Shad'har the Insatiable) -- Avoidable?
-- TODO: Umbral Breath (Shad'har the Insatiable) -- Avoidable?
-- TODO: Entropic Breath (Shad'har the Insatiable) -- Avoidable?
-- TODO: Bubbling Breath (Shad'har the Insatiable) -- Avoidable?
-- TODO: Eye of N'Zoth (Il'gynoth, Corruption Reborn) -- Non-Tank
-- TODO: Twilight Breath (Vexiona) -- Non-Tank
-- TODO: Brutal Smash (Iron-Willed Enforcer) -- Mythic only, avoidable?
-- TODO: Twilight Decimator (Vexiona)
-- TODO: Madness Bomb (Carapace of N'Zoth) -- FF alert
-- TODO: Insanity Bomb (Carapace of N'Zoth) -- FF alert
-- TODO: Corrupted Viscera (N'Zoth) -- Avoidable?
-- TODO: Psychic Burst (N'Zoth) -- FF
-- TODO: Stupefying Glare (N'Zoth) -- Avoidable?

GTFO.SpellID["305978"] = {
  --desc = "Searing Breath (Wrathion)";
  sound = 3;
  tankSound = 0;
};

GTFO.SpellID["307974"] = {
  --desc = "Tail Swipe (Wrathion)";
  sound = 3;
};

GTFO.SpellID["314754"] = {
  --desc = "Shadow Crash (Umbral Seer)";
  sound = 3;
};

GTFO.SpellID["316383"] = {
  --desc = "Void Slam (Anubisath Sentinel)";
  sound = 3;
  tankSound = 0;
};

GTFO.SpellID["315013"] = {
  --desc = "Bursting Shadows (Aqir Shadowcrafter)";
  sound = 3;
};

GTFO.SpellID["311383"] = {
  --desc = "Torment (Dark Inquisitor Xanesh)";
  sound = 3;
};

GTFO.SpellID["315932"] = {
  --desc = "Brutal Smash (Iron-Willed Enforcer)";
  sound = 3;
};

GTFO.SpellID["314449"] = {
  --desc = "Sanguine Fountain (Living Blood)";
  sound = 3;
};

GTFO.SpellID["311547"] = {
  --desc = "Rain of Blood (Sanguimar)";
  sound = 3;
};

GTFO.SpellID["310614"] = {
  --desc = "Crushing Slam (Tentacle of Drest'agath)";
  sound = 3;
};

GTFO.SpellID["309961"] = {
  --desc = "Eye of N'Zoth (Il'gynoth)";
  sound = 3;
  tankSound = 0;
};

GTFO.SpellID["318123"] = {
  --desc = "Consumed by Void (N'zoth)";
  sound = 3;
};

GTFO.SpellID["317292"] = {
  --desc = "Collapsing Mindscape (N'zoth)";
  sound = 3;
};

GTFO.SpellID["313793"] = {
  --desc = "Flames of Insanity (N'zoth)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["318688"] = {
  --desc = "Corrupted Viscera (N'zoth)";
  sound = 3;
};

GTFO.SpellID["313461"] = {
  --desc = "Corrosion (Ka'zir)";
  applicationOnly = true;
  sound = 3;
};

GTFO.SpellID["310005"] = {
  --desc = "Void Eruption (Ra-den)";
  sound = 3;
};

GTFO.SpellID["315878"] = {
  --desc = "Occipital Blast (Fury of N'Zoth)";
  sound = 3;
};

GTFO.SpellID["315862"] = {
  --desc = "Thrashing Tentacle (Fury of N'Zoth)";
  sound = 3;
};

GTFO.SpellID["313564"] = {
  --desc = "Growth-Covered Tentacle (Fury of N'Zoth)";
  sound = 3;
};

end
